

Relation.SORTTYPE =
{
	Player.emKPLAYERRELATION_TYPE_BIDFRIEND,
	Player.emKPLAYERRELATION_TYPE_TRAINING,
	Player.emKPLAYERRELATION_TYPE_TRAINED,
	Player.emKPLAYERRELATION_TYPE_COUPLE,
	Player.emKPLAYERRELATION_TYPE_INTRODUCTION,
	Player.emKPLAYERRELATION_TYPE_BUDDY,
};

Relation.MAX_NUMBER_FRIEND	= 200;

function Relation:SyncRelationStart()
	me.Relation_InitRelationList();
end

function Relation:SyncRelationList(tbList)
	for nIndex in pairs(tbList) do
		me.Relation_AddRelation(tbList[nIndex])
	end
	CoreEventNotify(UiNotify.emCOREEVENT_RELATION_UPDATEPANEL);
end

function Relation:SyncAddRelationList(tbList)
	for nIndex in pairs(tbList) do
		me.Relation_AddRelation(tbList[nIndex])
	end
	CoreEventNotify(UiNotify.emCOREEVENT_RELATION_UPDATEPANEL);
end

function Relation:SyncRelationInfo(tbInfoList)
	if not tbInfoList then
		return 0;
	end
	
	for i = 1, #tbInfoList do
		me.Relation_SetRelationInfo(tbInfoList[i].szPlayer, tbInfoList[i]);
	end
	CoreEventNotify(UiNotify.emCOREEVENT_RELATION_REFRESHTRAIN);
	CoreEventNotify(UiNotify.emCOREEVENT_RELATION_UPDATEPANEL);
end

function Relation:OnAddRelation(szPlayer, nType)
	if me.HasRelation(szPlayer, 4) == 1 then
		me.Msg("Đối phương là kẻ thù, hãy xóa khỏi danh sách kẻ thù rồi mới thêm vào hảo hữu.")
		return
	end
	local tbRelationList, tbInfo, nNum = me.Relation_GetRelationList();
	if ((nType == Player.emKPLAYERRELATION_TYPE_BIDFRIEND or nType == Player.emKPLAYERRELATION_TYPE_TMPFRIEND) and
		nNum and self.MAX_NUMBER_FRIEND <= nNum) then
		me.Msg("Số hảo hữu đã đạt tối đa.");
		return;
	end
	
	me.CallServerScript({"RelationCmd", "AddRelation_C2S", szPlayer, nType});
end

function Relation:DelRelation(szPlayer, nType)
	local tbDel = me.Relation_DelRelation(nType, szPlayer)
	if not tbDel then
		return;
	end
	if (tbDel.nType == Player.emKPLAYERRELATION_TYPE_TRAINED or
		tbDel.nType == Player.emKPLAYERRELATION_TYPE_TRAINING or 
		tbDel.nType == Player.emKPLAYERRELATION_TYPE_BUDDY or
		tbDel.nType == Player.emKPLAYERRELATION_TYPE_INTRODUCTION or
		tbDel.nType ==  Player.emKPLAYERRELATION_TYPE_COUPLE) then
		tbDel.nType = Player.emKPLAYERRELATION_TYPE_BIDFRIEND;
		me.Relation_AddRelation(tbDel);
	end
	CoreEventNotify(UiNotify.emCOREEVENT_RELATION_UPDATEPANEL);
end

function Relation:UpdateTrainingOption(nTeacher, nStudent)
	CoreEventNotify(UiNotify.emCOREEVENT_SYNC_TRAINING_OPTION, nTeacher, nStudent);
end
function Relation:SelfCheckInTime(nCheckTime)
	me.SetMySelfCheckTime(nCheckTime);
end

function Relation:CmdApplyTeacher(szPlayerName)
	me.TrainingApply(szPlayerName);
end
