local uiExpbar = Ui:GetClass("expbar");
local tbObject   = Ui.tbLogic.tbObject;
local tbMouse    = Ui.tbLogic.tbMouse;
local TXT_EXP	= "TxtExp";
local PRG_EXP	= "ImgPartExp";

uiExpbar.UIGROUP		= Ui.UI_EXPBAR;

function uiExpbar:OnOpen()
	self:UpdateExp();
end

function uiExpbar:OnClose()
	
end

function uiExpbar:UpdateExp()
	local nExp = me.GetExp();
	local nUpLevelExp = me.GetUpLevelExp();
	local nExpPercent = 0;
	
	if (nUpLevelExp > 0) then
		nExpPercent = math.floor(nExp / nUpLevelExp * 10000);
	end
	local nWholeNumber = math.floor(math.abs(nExpPercent) / 100);
	
	local szSign = "";
	local nDecimal;
	if nExpPercent < 0 then
		nDecimal = 100 - (nExpPercent % 100);
		szSign = "-";
	else	
		nDecimal = nExpPercent % 100;
	end
	Txt_SetTxt(self.UIGROUP, TXT_EXP, string.format("%s%d.%02d%%", szSign, nWholeNumber, nDecimal));
	Prg_SetPos(self.UIGROUP, PRG_EXP, nExpPercent / 10);
end

function uiExpbar:OnMouseEnter(szWnd)
	local nExp = me.GetExp();
	local nUpLevelExp = me.GetUpLevelExp();
	Wnd_ShowMouseHoverInfo(self.UIGROUP, szWnd, "", "Kinh nghiệm: "..nExp.."\nKinh nghiệm cần: "..nUpLevelExp);
end

function uiExpbar:RegisterEvent()
	local tbRegEvent = 
	{
		{ UiNotify.emCOREEVENT_SYNC_EXP,		self.UpdateExp },
	};
	return tbRegEvent;
end

function uiExpbar:OnEnterGame()
	UiManager:OpenWindow(self.UIGROUP);	
end

function uiExpbar:_Init()
	self.EnterGame_bak	= self.EnterGame_bak or Ui.EnterGame;
	function Ui:EnterGame()
		uiExpbar.EnterGame_bak(Ui);
		uiExpbar:OnEnterGame();
	end
end
uiExpbar:_Init();